/********************************************************************
**	ZombieBot v.1.7 by Mini_Midget (Originaly shino's)
**
**	Requires cstrike, fun and engine module.
**	Cvars:	
**	zbot_hp - sets health for zombies. Default = 450.
**	zbot_ap - sets armor for zombies. Default = 300.
**      zbot_z-speed - sets speed for zombies. Default = 550.0.
**	zbot_footsteps - Sets zombies to have silient run. Default = 1/ON.
**	zbot_dark - Sets the mod to dark but not pitch black. Default = 0/OFF.
**	zbot_h-speed - CT's have a reduced speed. Default = 200.0
**
**	CREDITS:
**	shino for making the bones of this plugin and then handing it to me.
**	riton for the fixed zombie model.
**	v3x helped with the backspeed part
**	Hawk552 for making the carapace part working
**	Many thanks to the scripting help forum (they teached me alot)
**	
**	Releases:
**
**	1.7
**	- Real players can join zombies but bots can't join CT's
**	- Zombies have lowered gravity
**	- Added human speed. (Removed the other ones as it screwed everything else)
**	- Added the ability to taunt. "+taunt"
**	- Humans get $1200 bonus every round to balance things out
**	- Zombies have a better looking knife (I dont have credits for who did them)
**
**	1.6
**	- No longer supporting Zbot
**	- Works with podbot_mm (Won't work with other bots)
**	- CT's sidespeed is reduced
** 	- All bots (Should work with all) have a default Zombie name infront of theirs
**
**	1.5
**	- Fix models
**	- New models work properly (CREDITS TO riton)
**	- Zombies have silient run
**	- CT's backspeed is reduced
**
**	1.4 (Mini_Midget's)
**	- added dark mode
**	- A new start message
**	- Shorten the cvars
**	- Renamed .sma to "zbot"
**	- Default speed for zombies is now 300
**
**	1.3
**	- added hud message on player's death
**	- zombies drop weapons picked up from other players
**	- zombies having amount of speed.
**	1.2
**	- fixed some problems
**	1.1
**	- repaired restarting problems at auto-team balance
**	- sets buy time to 15 seconds and round time to 3 minutes
**	- zombies get 900 armor
**	1.0
**  	- first release
**
**********************************************************************/
#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <engine> 
#include <fun>

new CTModels[] =  
{     
"urban", "gsg9",   
"gign", "sas"   
}  

public plugin_init() {
	register_plugin("ZombieBot", "1.7", "Mini_Midget")
	register_dictionary("zombiebot.txt")

	register_cvar("zbot" , "1")
	register_cvar("zbot_hp" , "450")
	register_cvar("zbot_ap" , "300")
	register_cvar("zbot_z-speed" , "550.0")
	register_cvar("zbot_h-speed" , "200.0")
	register_cvar("zbot_footsteps" , "1")

	register_concmd("zbot_dark", "admin_dark", ADMIN_KICK, " ")
	register_concmd("+taunt", "taunt")

	register_event("CurWeapon", "check_speed", "be")
	register_event("CurWeapon" , "set_claws" , "be" , "1=1")
	register_event("Damage","carapace","be")
	register_event("WeapPickup", "WeaponPickedUp", "be", "1!29")

	register_logevent("round_start",2,"0=World triggered","1=Round_Start")
}

public plugin_precache() {
	precache_model("models/player/zbot/zbot.mdl")
	precache_model("models/v_claws.mdl")
	precache_sound("zombie/zo_attack1.wav")
	precache_sound("barney/diebloodsucker.wav")
}


public client_putinserver() {
	if( get_cvar_num("zbot") != 1 ) 
		return PLUGIN_CONTINUE
	
	if (get_playersnum() == 1) {
		set_cvar_num("mp_buytime", 0.25)
		set_cvar_num("mp_roundtime", 3)
		set_cvar_num("mp_autoteambalance", 0)
		set_cvar_num("mp_limitteams", 0)
	}
	return PLUGIN_CONTINUE
}

public client_connect(id) { 
	new newName[33]  
	get_user_info(id,"name",newName,32)  
	
	if (cs_get_user_team(id) == CS_TEAM_T && containi(newName,"z0mB!3|") == -1)  
		{  
		format(newName,32,"z0mB!3| %s",newName)  
		set_user_info(id,"name",newName)     
	}  
} 

public round_start() {
	set_task(0.1,"BotNumber")
	set_task(0.3,"TeamCheck")
	set_task(0.6,"TeamSet")
	set_task(1.0,"Make_Players")
	set_task(2.5,"StartMsg")
	set_task(3.0,"SetKnife")
	
}

public BotNumber() {
	if( get_cvar_num("zbot") != 1 ) 
		return PLUGIN_CONTINUE
	
	new player_num, bot_num, rplayer_num
	player_num = get_playersnum()
	bot_num = get_cvar_num("pb_minbots")
	rplayer_num = player_num - bot_num
	
	if (rplayer_num > 0 && rplayer_num < 3) {
		set_cvar_num("pb_minbots", 1)
	}
	if (rplayer_num > 2 && rplayer_num < 5) {
		set_cvar_num("pb_minbots", 1)
	}
	if (rplayer_num > 4 && rplayer_num < 7) {
		set_cvar_num("pb_minbots", 2)
	}
	if (rplayer_num > 6 && rplayer_num < 9) {
		set_cvar_num("pb_minbots", 2)
	}
	if (rplayer_num > 8 && rplayer_num < 11) {
		set_cvar_num("pb_minbots", 3)
	}
	if (rplayer_num > 10 && rplayer_num < 13) {
		set_cvar_num("pb_minbots", 3)
	}
	if (rplayer_num > 12 && rplayer_num < 15) {
		set_cvar_num("pb_minbots", 4)
	}
	if (rplayer_num > 14 && rplayer_num < 17) {
		set_cvar_num("pb_minbots", 4)
	}
	return PLUGIN_CONTINUE
}

public Make_Players(players[]) {
	if( get_cvar_num("zbot") != 1 ) 
		return PLUGIN_CONTINUE
	
	new players[32],num,i,id,CsArmorType:ArmorType = CS_ARMOR_VESTHELM
	get_players(players,num) 
	for(i = 0; i <= num; i++) {
		id = players[i]
		new money
		money = cs_get_user_money(id)
		
		if (is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_T) {
			set_user_health(id, get_cvar_num ("zbot_hp"))
			cs_set_user_armor(id, get_cvar_num ("zbot_ap"),ArmorType)
			set_user_gravity(id, 0.75)
			
			set_user_footsteps(id,get_cvar_num("zbot_footsteps"))
			cs_set_user_money(id, money - 16000)
			cs_set_user_nvg(id, 1)
			cs_set_user_model(id,"zbot")
		}
		
		else if (is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_CT)
		{
			cs_set_user_model(id, CTModels)
			cs_set_user_money(id, money + 1200)
			} else {
			cs_reset_user_model(id)
		}
	}
	return PLUGIN_CONTINUE
}   

public check_speed(id)
{
	if( get_cvar_num("zbot") != 1 ) 
		return PLUGIN_CONTINUE
		
		
	if (cs_get_user_team(id) == CS_TEAM_T)
	{
		set_user_maxspeed(id, float (get_cvar_num("zbot_z-speed")))
	}
	else if (cs_get_user_team(id) == CS_TEAM_CT)
	{
		set_user_maxspeed(id, float (get_cvar_num("zbot_h-speed")))
		} else {
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}

public set_claws(id) 
	{
	if(!is_user_alive(id) && !is_user_connected(id)) 
		return PLUGIN_CONTINUE
	
	
	if(cs_get_user_team(id) != CS_TEAM_T)
		return PLUGIN_CONTINUE
	
	
	new weapid = read_data(2)
	
	switch(weapid) 
	{
		case CSW_KNIFE: 
		{
			entity_set_string(id, EV_SZ_viewmodel, "models/v_claws.mdl")
		}
	}
	return PLUGIN_CONTINUE;
} 


public TeamSet(players[]) {
	if( get_cvar_num("zbot") != 1 ) 
		return PLUGIN_CONTINUE
	
	new players[32],num,i,id
	get_players(players,num) 
	for(i = 0; i < num; i++) {
		id = players[i]
		if (is_user_bot(id) && is_user_alive(id)) {
			cs_set_user_team(id,CS_TEAM_T)
			cs_set_user_model(id,"zbot")
		}
	}
	return PLUGIN_CONTINUE
}

public TeamCheck(players[]) {
	if( get_cvar_num("zbot") != 1 ) 
		return PLUGIN_CONTINUE
	
	new players[32],num,i,id
	get_players(players,num) 
	for(i = 0; i < num; i++) {
		id = players[i]
		if (is_user_alive(id)) {
			if (is_user_bot(id) && cs_get_user_team(id) == CS_TEAM_CT) {
				set_cvar_num("sv_restartround", 1)
			}
		}
	}
	return PLUGIN_CONTINUE
}

public StartMsg() {
	if( get_cvar_num("zbot") != 1 ) 
		return PLUGIN_CONTINUE
	
	new players[32], Tcount, zombies, real, bots
	real = get_players(players,Tcount,"e","TERRORIST")
	bots = get_cvar_num ("pb_minbots")
	zombies = real + bots
	
	client_print(0,print_chat,"%L",LANG_PLAYER,"ZOMBIEBOT_NUMBER",zombies)	
	client_print(0,print_chat,"%L",LANG_PLAYER,"ZOMBIEBOT_HEALTHMSG",get_cvar_num("zbot_hp"))
	client_print(0,print_chat,"%L",LANG_PLAYER,"ZOMBIEBOT_ARMOURMSG",get_cvar_num("zbot_ap"))
	client_print(0,print_chat,"%L",LANG_PLAYER,"ZOMBIEBOT_SPEEDMSG",get_cvar_num("zbot_z-speed"))
	
	return PLUGIN_CONTINUE
}

public SetKnife(index) {
	if( get_cvar_num("zbot") != 1 ) 
		return PLUGIN_CONTINUE
	
	new players[32],num,i
	get_players(players,num) 
	for(i = 0; i <= num; i++) {
		new id = players[i]
		if (is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_T) {
			strip_user_weapons(id)
			give_item(id,"weapon_knife")
		}
	}
	return PLUGIN_CONTINUE
}

public RemovePickedWeapon(id) {
	if( get_cvar_num("zbot") != 1 ) 
		return PLUGIN_CONTINUE
	
	if (is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_T) {
		strip_user_weapons(id)
		give_item(id, "weapon_knife")
	}
	return PLUGIN_HANDLED
} 

public WeaponPickedUp(id) {
	set_task(0.1, "RemovePickedWeapon", id)
}

public lighting(id)
{
	client_cmd(0, "spk ambience/thunder_clap.wav")
}

public admin_dark(id, level, cid) {
	if (!cmd_access(id, level, cid, 2))
		return PLUGIN_HANDLED
	
	new arg[32]
	read_argv(1,arg,31); 
	if(arg[0] == '1') 
	{	
		set_hudmessage(0, 255, 0, -1.0, 0.2, 0, 6.0, 4.0)
		show_hudmessage(0, "Night Hour ENABLED")
		set_lights("aaaaaaaaaaabbbbbaaa")
		set_task(12.0, "lighting", 0, _, _, "b")
		client_cmd(0, "spk ambience/wolfhowl01.wav")
		client_print(0, print_chat, "[Zombie Mod] Remember that zombies have night vision!")
	}
	
	else if(arg[0] == '0') 
	{
		set_hudmessage(0, 255, 0, -1.0, 0.2, 0, 6.0, 4.0)
		show_hudmessage(0, "Night Hour DISABLED")
		set_lights("#OFF")
	}
	return PLUGIN_HANDLED
}

public carapace(id) {
	if( get_cvar_num("zbot") != 1 ) 
		return PLUGIN_CONTINUE
	
	if(!is_user_alive(id) || !is_user_connected(id)) 
		return PLUGIN_CONTINUE
	
	new CsArmorType:catArmor,iArmor = cs_get_user_armor(id,catArmor),iHealth = get_user_health(id)
	if(iArmor < 10)
		return PLUGIN_CONTINUE
	
	new iDamage = read_data(2)
	new iValue = iArmor - (iDamage / 2)
	if(iValue < 0)
		iDamage += iValue
	
	set_user_armor(id,clamp(iValue,0,255))
	set_user_health(id,iHealth + iDamage)
	
	return PLUGIN_CONTINUE
}

public taunt(id) {
	if( get_cvar_num("zbot") != 1 ) 
		return PLUGIN_CONTINUE
	
	if(!is_user_alive(id) || !is_user_connected(id)) 
		return PLUGIN_CONTINUE
	
	if(is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_T)
	{
		emit_sound(id,CHAN_VOICE, "zombie/zo_attack1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	}
	else if(is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_CT) 
	{ 
		emit_sound(id,CHAN_VOICE, "barney/diebloodsucker.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
		} else {
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang5129\\ f0\\ fs16 \n\\ par }
*/
