/* AMX MOD X
*   Matrix Mod - xp.inl
*
* (c) Copyright 2006 by Knekter
*
* This file is provided as is (no warranties)
*/

stock MM_XP_kill(killer, victim, type)
{
	// Determine the type of XP
	if(type == xp_normal || type == xp_tk || type == xp_suicide)
	{
		// Get users current XP
		new xp = MM_get_pdata(killer, pdata_xp);

		if(type == xp_normal && xp < 5000)
			xp += 10 + (MM_get_pdata(victim, pdata_level) * 10);
		else
			xp -= 10 + (MM_get_pdata(victim, pdata_level) * 10);

		// Get user level and set XP
		MM_XP_getlevel(killer, xp);
		MM_set_pdata(killer, pdata_xp, xp);
	}
	else if(type == xp_power || type == xp_ultimate)
	{
		// Get users current XP
		new xp = MM_get_pdata(killer, pdata_xp);

		if(xp >= 5000)
			return 0;

		if(type == xp_power)
			xp += 10 + (MM_get_pdata(victim, pdata_level) * 11);
		else
			xp += 10 + (MM_get_pdata(victim, pdata_level) * 12);

		// Get user level and set XP
		MM_XP_getlevel(killer, xp);
		MM_set_pdata(killer, pdata_xp, xp);
	}

	MM_UTIL_showinfo(killer);

	return 0;
}

stock MM_XP_save(id)
{
	// Check if action is to all users
	if(id != xp_all)
	{
		new authid[36], key[64], xp[5];
		get_user_authid(id, authid, 35);

		// Make sure they are connected
		if(!equal(authid, "STEAM_ID_PENDING"))
		{
			// Format key and set value
			format(key, 63, "%s-MMXP", authid);
			format(xp, 4, "%i", MM_get_pdata(id, pdata_xp));
			set_vaultdata(key, xp);
		}
	}
	else
	{
		new authid[36], key[64], xp[5];

		// Get all players
		new players[32], num, p, id
		get_players(players, num);

		for(p = 0; p < num; p++)
		{
			id = players[p];
			get_user_authid(id, authid, 35);

			// Make sure they are connected
			if(!equal(authid, "STEAM_ID_PENDING"))
			{
				// Format key and set value
				format(key, 63, "%s-MMXP", authid);
				format(key, 4, "%s", MM_get_pdata(id, pdata_xp));
				set_vaultdata(key, xp);
			}
		}
	}

	return 0;
}

stock MM_XP_load(id)
{
	// Check if action is to all users
	if(id != xp_all)
	{
		new authid[36], key[64], xp[5];
		get_user_authid(id, authid, 35);

		// Make sure they are connected
		if(!equal(authid, "STEAM_ID_PENDING"))
		{
			// Format the key
			format(key, 63, "%s-MMXP", authid);

			// Check the key to see if it is empty
			if(vaultdata_exists(key))
			{
				// Retrieve and set XP
				get_vaultdata(key, xp, 4);
				MM_XP_getlevel(id, str_to_num(xp));
				MM_set_pdata(id, pdata_xp, str_to_num(xp));
			}
		}
	}
	else
	{
		new authid[36], key[64], xp[5];

		// Get all players
		new players[32], num, p, id
		get_players(players, num);

		for(p = 0; p < num; p++)
		{
			id = players[p];
			get_user_authid(id, authid, 35);

			// Make sure they are connected
			if(!equal(authid, "STEAM_ID_PENDING"))
			{
				// Format the key
				format(key, 63, "%s-XP", authid);

				// Check the key to see if it is empty
				if(vaultdata_exists(key))
				{
					// Retrieve and set XP
					get_vaultdata(key, xp, 4);
					MM_XP_getlevel(id, str_to_num(xp));
					MM_set_pdata(id, pdata_xp, str_to_num(xp));
				}
			}
		}
	}

	return 0;
}

stock MM_XP_getlevel(id, xp)
{
	new level;
	for(level = 0; level < 7; level++)
	{
		if(xp < g_levels[level])
			break;
	}

	MM_set_pdata(id, pdata_level, level);

	return 0;
}