/* AMX MOD X
*   Matrix Mod - utils.inl
*
* (c) Copyright 2006 by Knekter
*
* This file is provided as is (no warranties)
*/

stock MM_UTIL_showinfo(id)
{
	new message[56], class, xp, level;

	// Get user class/XP/level
	class = MM_get_pdata(id, pdata_class);
	xp = MM_get_pdata(id, pdata_xp);
	level = MM_get_pdata(id, pdata_level);

	// Format the message
	format(message, 55, "[%s] (XP: %i/%i) (Level: %i)", g_classes[class], xp, g_levels[level], level);

	// Display the message
	message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("StatusText"), {0, 0, 0}, id);
	write_byte(0);		// Line
	write_string(message);	// Message
	message_end();

	return 0;
}

stock MM_UTIL_showtime(id, time, bool:first)
{
	new sprite[9];

	// If not first message remove old number
	if(first == false || time == -1)
	{
		new oldsprite[9];
		format(oldsprite, 9, "number_%i", time + 1);

		// Remove the message
		MM_UTIL_showicon(id, 0, oldsprite);

		if(time == -1)
			return 0;
	}

	// Format new sprite
	format(sprite, 8, "number_%i", time);

	// Display the message
	MM_UTIL_showicon(id, 1, sprite);

	return 0;
}

stock MM_UTIL_removetime(id, bool:power)
{
	new sprite[9], time;

	// For power?
	if(power == true)
		time = MM_get_pdata(id, pdata_time1) + 1;
	else
		time = MM_get_pdata(id, pdata_time2) + 1;

	// Format the sprite
	format(sprite, 8, "number_%i", time);

	// Remove the message
	MM_UTIL_showicon(id, 0, sprite);

	return 0;
}

stock MM_UTIL_showicon(id, status, icon[])
{
	// Display the icon
	message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("StatusIcon"), {0, 0, 0}, id);
	write_byte(status);	// Status
	write_string(icon);	// Sprite
	write_byte(0);		// Red
	write_byte(255);	// Green
	write_byte(0);		// Blue
	message_end();

	return 0;
}