/* AMX MOD X
*   Matrix Mod - stocks.inl
*
* (c) Copyright 2006 by Knekter
*
* This file is provided as is (no warranties)
*/

stock MM_is_active()
{
	return get_cvar_num("matrix_mode");
}

stock MM_set_pdata(id, data, value)
{
	g_pdata[id][data] = value;
	return 0;
}

stock MM_get_pdata(id, data)
{
	return g_pdata[id][data];
}

stock MM_set_pdata_defaults(id)
{
	g_pdata[id][pdata_power] = 1;
	g_pdata[id][pdata_ultimate] = 1;
	g_pdata[id][pdata_disguised] = 0;
	g_pdata[id][pdata_time1] = 5;
	g_pdata[id][pdata_time2] = 8;

	return 0;
}

stock MM_damage(attacker, victim, weapon[], damage, type)
{
	// Check to see if user will die
	if(get_user_health(victim) - damage <= 0)
		MM_kill(attacker, victim, weapon, 0);
	else
		fakedamage(victim, weapon, float(damage), type); 

	new name[32], origin[3];
	get_user_name(attacker, name, 31);
	get_user_origin(victim, origin, 0);

	// Create the damage message
	message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("Damage"), {0, 0, 0}, victim);
	write_byte(0);		 // Damage save
	write_byte(damage);	 // Damage take
	write_long(type);	 // Damage type
	write_coord(origin[0]);	 // X
	write_coord(origin[1]);	 // Y
	write_coord(origin[2]);	 // Z
	message_end();

	// Display friendly fire attack message
	if(get_user_team(attacker) == get_user_team(victim))
		client_print(0, print_chat, "%s attacked a teammate", name);

	return 0;
}

stock MM_kill(killer, victim, weapon[], headshot)
{
	user_silentkill(victim);
	set_msg_block(get_user_msgid("DeathMsg"), BLOCK_NOT);
	make_deathmsg(killer, victim, headshot, weapon);

	MM_remove_tasks(victim);

	// Check for team kill or not
	if(get_user_team(killer) != get_user_team(victim))
	{
		set_user_frags(killer, get_user_frags(killer) + 1);

		new money = cs_get_user_money(killer) + 300;
		if(money >= 16000)
			cs_set_user_money(killer, 16000);
		else
			cs_set_user_money(killer, cs_get_user_money(killer) + 300, 1);

		// Give XP accordingly
		if(!equal(weapon, "rocket"))
			MM_XP_kill(killer, victim, xp_normal);
		else
			MM_XP_kill(killer, victim, xp_ultimate);
	}
	else
	{
		// Check for suicide
		if(killer != victim)
		{
			set_user_frags(killer, get_user_frags(killer) - 1);

			new money = cs_get_user_money(killer) - 3300;
			if(money <= 0)
				cs_set_user_money(killer, 0);
			else
				cs_set_user_money(killer, cs_get_user_money(killer) - 3300, 1);

			MM_XP_kill(killer, victim, xp_tk);
		}
		else
			MM_XP_kill(killer, victim, xp_suicide);
	}
	
	// Create the score info message
	message_begin(MSG_BROADCAST, get_user_msgid("ScoreInfo"));
	write_byte(killer);			 // Destination
	write_short(get_user_frags(killer));	 // Frags
	write_short(cs_get_user_deaths(killer)); // Deaths
	write_short(0);				 // Player class
	write_short(get_user_team(killer));	 // Team
	message_end(); 
	
	new kname[32], vname[32], kauthid[32], vauthid[32], kteam[10], vteam[10];

	get_user_name(killer, kname, 31);
	get_user_team(killer, kteam, 9);
	get_user_authid(killer, kauthid, 31);

	get_user_name(victim, vname, 31);
	get_user_team(victim, vteam, 9);
	get_user_authid(victim, vauthid, 31);

	if(killer != victim)
	{
		log_message("^"%s<%d><%s><%s>^" killed ^"%s<%d><%s><%s>^" with ^"%s^"", 
		kname, get_user_userid(killer), kauthid, kteam, 
 		vname, get_user_userid(victim), vauthid, vteam, weapon);
	}
	else
	{
		log_message("^"%s<%d><%s><%s>^" committed suicide", kname, get_user_userid(killer), kauthid, kteam);
	}

 	return 0;
}

stock MM_remove_tasks(id)
{
	if(id == -1)
	{
		g_bullettime = false;

		new players[32], num, p, pid;
		get_players(players, num, "a");

		for(p = 0; p < num; p++)
		{
			pid = players[p];

			// Reset all properties
			set_user_hitzones(pid, 0, 255);
			set_user_hitzones(0, pid, 255);
			set_user_footsteps(pid, 1);
			set_user_noclip(pid, 0);
			set_user_godmode(pid, 0);
			set_user_rendering(pid);
			set_user_maxspeed(pid, 320.0);

			// Is users power on?
			if(task_exists(pid + 3475))
			{
				remove_task(pid + 3475);
				MM_UTIL_removetime(pid, true);
			}
			else if(task_exists(pid + 5667))
			{
				remove_task(pid + 5667);
				MM_UTIL_removetime(pid, false);
			}
		}
	}
	else
	{
		new class = MM_get_pdata(id, pdata_class);

		// Is users power on?
		if(task_exists(id + 3475))
		{
			// Off now and get class
			remove_task(id + 3475);

			switch(class)
			{
				case smith:
				{
					cs_reset_user_model(id);
					set_user_footsteps(id, 1);
				}

				case twins: set_user_rendering(id);
			}

			MM_UTIL_removetime(id, true);
		}
		else if(task_exists(id + 5667))
		{
			// Off now and get class
			remove_task(id + 5667);

			switch(class)
			{
				case neo:
				{
					// Turn bullet time off
					g_bullettime = false;
					new players[32], num, p, pid;
					get_players(players, num);

					// Reset player properties
					for(p = 0; p < num; p++)
					{
						pid = players[p];
						set_user_hitzones(pid, 0, 255);
						set_user_hitzones(0, pid, 255);
						set_user_maxspeed(pid, 320.0);
					}
				}

				case twins:
				{
					// Remove no clip
					set_user_hitzones(0, id, 255);
					set_user_noclip(id, 0);
					set_user_rendering(id);
				}
			}

			MM_UTIL_removetime(id, false);
		}
	}

	return 0;
}