/* AMX MOD X
*   Matrix Mod - events.inl
*
* (c) Copyright 2006 by Knekter
*
* This file is provided as is (no warranties)
*/

public hook_cvar()
{
	new mode = MM_is_active();

	// Turned MM on/off?
	if(mode != mm_mode)
	{
		if(mode == 0)
		{
			MM_XP_save(xp_all);
			MM_remove_tasks(-1);
		}
		else
			MM_XP_load(xp_all);

		set_cvar_num("sv_restartround", 1);
		mm_mode = mode;
	}
}

public hook_roundstart()
{
	if(!MM_is_active())
		return PLUGIN_CONTINUE;

	// Retrieve alive players
	new players[32], num;
	get_players(players, num, "a");

	new p, id;

	for(p = 0; p < num; p++)
	{
		id = players[p];
		MM_set_pdata_defaults(id);

		// Reset origin
		g_origin[id][0] = 0;
		g_origin[id][1] = 0;
		g_origin[id][2] = 0;

		// Show menu if human
		if(MM_get_pdata(id, pdata_class) == human)
			MM_MENU_show(id);
		else
			MM_UTIL_showinfo(id);
	}

	return PLUGIN_CONTINUE;
}

public hook_spawn(id)
{
	if(!MM_is_active())
		return PLUGIN_CONTINUE;

	MM_set_pdata_defaults(id);

	// Reset origin
	g_origin[id][0] = 0;
	g_origin[id][1] = 0;
	g_origin[id][2] = 0;

	// Show menu if human
	if(MM_get_pdata(id, pdata_class) == human)
		MM_MENU_show(id);
	else
		MM_UTIL_showinfo(id);

	// Check to see if bullet time is on!
	if(g_bullettime == true)
	{
		set_user_hitzones(id, 0, 0);
		set_user_hitzones(0, id, 0);
	}

	return PLUGIN_CONTINUE;
}

public hook_death()
{
	if(!MM_is_active())
		return PLUGIN_CONTINUE;

	// Retrieve killer/victim
	new killer = read_data(1);
	new victim = read_data(2);

	// Check for suicide
	if(killer > 0 && killer <= 32 && killer != victim)
	{
		// Check team kill
		if(get_user_team(killer) != get_user_team(victim))
			MM_XP_kill(killer, victim, xp_normal);
		else
			MM_XP_kill(killer, victim, xp_tk);
	}
	else
		MM_XP_kill(victim, victim, xp_suicide);

	MM_remove_tasks(victim);

	return PLUGIN_CONTINUE;
}

public hook_damage(id)
{
	if(!MM_is_active())
		return PLUGIN_CONTINUE;

	// Is the user disguised
	if(MM_get_pdata(id, pdata_disguised) == 1)
	{
		remove_task(id + 3475);
		MM_UTIL_removetime(id, true);
		cs_reset_user_model(id);
		set_user_footsteps(id, 1);
	}

	return PLUGIN_CONTINUE;
}

public hook_attack(id)
{
	if(!MM_is_active() || g_bullettime)
		return PLUGIN_CONTINUE;

	// Retrieve weapon/clip
	new weapid = read_data(2);
	new clip = read_data(3);

	// Just entered the game?
	if(MM_get_pdata(id, pdata_prevweap) == 0)
		MM_set_pdata(id, pdata_prevweap, weapid);

	// Check to see if the same weapon is being used
	if(MM_get_pdata(id, pdata_prevclip) > clip && MM_get_pdata(id, pdata_prevweap) == weapid)
		MM_ENT_create(id, ent_bullet, weapid);

	// Set player data
	MM_set_pdata(id, pdata_prevweap, weapid);
	MM_set_pdata(id, pdata_prevclip, clip);

	return PLUGIN_CONTINUE;
}

public hook_weapon(id)
{
	if(!MM_is_active() || g_bullettime)
		return PLUGIN_CONTINUE;

	// Check if owner of bullet time
	if(!task_exists(id + 5667))
		set_user_maxspeed(id, 240.0);

	return PLUGIN_CONTINUE;
}