/* AMX MOD X
*   Matrix Mod - matrix.sma
*
* (c) Copyright 2006 by Knekter
*
* This file is provided as is (no warranties)
*/

#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <cstrike>
#include <fun>

new mm_mode = 1;

new g_pdata[33][10];
new g_origin[33][3];
new g_colors[2][3];
new g_sprites[4];

new bool:g_bullettime = false;

#include "mm_inl/const.inl"
#include "mm_inl/utils.inl"
#include "mm_inl/xp.inl"
#include "mm_inl/cmds.inl"
#include "mm_inl/menu.inl"
#include "mm_inl/entity.inl"
#include "mm_inl/events.inl"
#include "mm_inl/stocks.inl"

public plugin_init()
{
	register_plugin(MM_PLUGIN, MM_VERSION, MM_AUTHOR);

	register_cvar("matrix_mode", "1");
	set_task(1.0, "hook_cvar", 5345, _, _, "a");

	register_menu("cmenu", 1023, "hook_classmenu");

	register_clcmd("say", "hook_say");
	register_clcmd("say_team", "hook_say");

	register_clcmd("mm_xp", "clcmd_xp", ADMIN_KICK, ": <authid, nick or #userid> <amount>");
	register_clcmd("mm_level", "clcmd_level", ADMIN_KICK, ": <authid, nick or #userid> <level>");
	register_clcmd("mm_class", "clcmd_class", ADMIN_KICK, ": <authid, nick or #userid> <class>");

	register_clcmd("mm_power", "clcmd_power");
	register_clcmd("mm_ultimate", "clcmd_ultimate");

	register_event("DeathMsg", "hook_death", "a");
	register_event("Damage", "hook_damage", "b",  "2!0");
	register_event("ResetHUD", "hook_spawn", "b");
	register_event("CurWeapon", "hook_attack", "be", "1=1", "2!4", "2!6", "2!9", "2!25", "2!29");
	register_event("CurWeapon", "hook_weapon", "be");

	register_logevent("hook_roundstart", 2, "0=World triggered", "1=Round_Start");

	set_error_filter("error_filter");

	g_colors[ent_bullet][0] = 193;
	g_colors[ent_bullet][1] = 193;
	g_colors[ent_bullet][2] = 191;
	g_colors[ent_rocket][0] = 255;
	g_colors[ent_rocket][1] = 0;
	g_colors[ent_rocket][2] = 0;
}

public plugin_precache()
{
	precache_model("models/shell.mdl");
	precache_model("models/rpgrocket.mdl");

	precache_sound("weapons/rocketfire1.wav");

	g_sprites[ent_bullet] = precache_model("sprites/zbeam4.spr");
	g_sprites[ent_rocket] = precache_model("sprites/smoke.spr");
	g_sprites[ent_smoke] = precache_model("sprites/steam1.spr");
	g_sprites[ent_explode] = precache_model("sprites/zerogxplode.spr");
}

public client_connect(id)
{
	if(!MM_is_active())
		return PLUGIN_CONTINUE;

	// Reset player data
	new data;
	for(data = 0; data < 9; data++)
		MM_set_pdata(id, data, 0);

	// Set origin to default
	g_origin[id][0] = 0;
	g_origin[id][1] = 0;
	g_origin[id][2] = 0;

	console_cmd(id, "hud_centerid 0");

	MM_XP_load(id);
	return PLUGIN_CONTINUE;
}

public client_disconnect(id)
{
	if(!MM_is_active())
		return PLUGIN_CONTINUE;

	// Save user
	MM_XP_save(id);
	return PLUGIN_CONTINUE;
}

public plugin_end()
{
	if(!MM_is_active())
		return PLUGIN_CONTINUE;

	// Save all users
	MM_XP_save(xp_all);
	return PLUGIN_CONTINUE;
}

public error_filter(err, debugging, msg[]) 
{ 
	new buffer[512];
	dbg_fmt_error(buffer, 511);

	if(buffer[0])
		server_print("Debug msg: %s", buffer);

	if(!debugging)
		return PLUGIN_HANDLED;

	new trace = dbg_trace_begin();
	if(!trace)
	{ 
		server_print("no trace found!");
		return PLUGIN_HANDLED;
	} 
     
	new num = 0;
	new func[32], file[64], line;

	while (trace)
	{
		dbg_trace_info(trace, line, func, 31, file, 63);
		server_print(" [%d] file: %s func: %s line: %d", num++, file, func, line);
		trace = dbg_trace_next(trace);
	}
     
	return PLUGIN_HANDLED;
}