/* Amx Mod X Script
	Map Generator

   By $uicid3

--------------------
   Installation:
	Compile locally so you can configure.

	Use the line starting with #define to deside wether or not
	to list basic maps. Such as dust, dust2, etc...

	Reason for this:
	On windows the map files dont have to be in directory.
	However if your running linux make sure that it is set to 0 or
	else the basic maps will be double listed.
--------------------
   Usage:
	Load plugin. On map change all maps will be put into
	maps.ini and mapcycle.txt.
	This will remove any old maps and/or put new maps in.
--------------------
   Credit:
	pdoubleopdawg / DahVid - For Idea
	Cheap Suit - For basic code
--------------------
   Cvars:
	amx_generate_maps
		0 - Don't
		1 - maps.ini
		2 - maps.ini + mapcycle.txt
		3 - mapcycle.txt
--------------------
   Changelog:
	1.2 - Changed cvar amx_generate_maps
	1.1 - Fixed bug
	1.0 - Initial release
------------------- 
   Enjoy!

*/

#include <amxmodx>
#include <amxmisc>

//#define START_WITH_BASIC	// uncomment to start with basic

new g_cvarGenerate

public plugin_init() 
{ 
	register_plugin("Map Generator", "1.2", "Suicid3");

	g_cvarGenerate = register_cvar("amx_generate_maps", "1");
}

public plugin_end()
{
	if(get_pcvar_num(g_cvarGenerate)) {
		server_print("[MAP GENERATOR] Generating maps.ini and mapcycle.txt");
		MakeMaps();
	}
}

stock MakeMaps()
{
	new szBaseDir[64], szMapDir[64], szMaps_ini[64],szMapCycle[64], szFileName[64];
	new szMap[64], MapLength, dirh , iMapGenerate;
	get_basedir(szBaseDir, 63);
	format(szMapDir, 63, "maps");
	format(szMaps_ini, 63, "%s/configs/maps.ini", szBaseDir);
	format(szMapCycle , 31 , "mapcycle.txt");

	iMapGenerate = get_pcvar_num(g_cvarGenerate);

	if(iMapGenerate <= 2)
		StartNew(szMaps_ini);
	if(iMapGenerate >= 2)
		StartNew(szMapCycle);

	if((dirh = open_dir(szMapDir , szFileName , 63)) == 0)
		return

	MapLength = (strlen(szFileName)-3);

	if(MapLength > 0 )
	{
		if(equali(szFileName[MapLength],"bsp") )
		{
			add(szMap, 64, szFileName , MapLength-1);

			if(iMapGenerate <= 2)
				write_file(szMaps_ini , szMap , -1);
			if(iMapGenerate >= 2)
				write_file(szMapCycle , szMap , -1);

			szMap[0] = 0;
		}
	}
	while(next_file(dirh , szFileName , 63)) {
		MapLength = (strlen(szFileName)-3);

		if(MapLength < 0) continue;

		if(equali(szFileName[MapLength],"bsp") )
		{
			add(szMap, 64, szFileName , MapLength-1);

			if(iMapGenerate <= 2)
				write_file(szMaps_ini , szMap , -1);
			if(iMapGenerate >= 2)
				write_file(szMapCycle , szMap , -1);


			szMap[0] = 0;
		}
	}
	return
}

stock StartNew( szMapFile[64] )
{

	if(file_exists(szMapFile))
		delete_file(szMapFile);

	new szMaps[356] , len;
	if(equali(szMapFile[strlen(szMapFile)-3] , "ini") )  //If maps.ini
	{
		len += format(szMaps , 355 , ";maps.ini Created by Map Generator^n;Plugin by $uicid3^n");
	}
	#if defined START_WITH_BASIC;
	len += format(szMaps[len] , len-355 , "as_oilrig^ncs_747^ncs_assault^ncs_backalley^ncs_estate^n");
	len += format(szMaps[len] , len-355 , "cs_havana^ncs_italy^ncs_militia^ncs_office^ncs_siege^n");
	len += format(szMaps[len] , len-355 , "de_airstrip^nde_aztec^nde_cbble^nde_chateau^nde_dust^n");
	len += format(szMaps[len] , len-355 , "de_dust2^nde_inferno^nde_nuke^nde_piranesi^nde_prodigy^n");
	len += format(szMaps[len] , len-355 , "de_storm^nde_survivor^nde_torn^nde_train^nde_vertigo");

	#endif
	write_file(szMapFile,szMaps,-1);
}