
/* AMX Mod script. 
* 
*  Anti-Camping 
*  by SpaceDude 
*  email: eayumns@nottingham.ac.uk 
* 
*  Console Commands 
* 
*  Server: 
*  "sv_anticamping" 1/0 - (enable/disable the plugin, default is 1) 
*
*  Revision History
*
*  - v1.01: - Camper is now slapped rather than health simply reduced (more noticeable ;)
*
*/

#include <amxmod> 

new playercoord0[33][3] 
new playercoord1[33][3] 
new playercoord2[33][3] 
new playercoord3[33][3] 
new playercoord4[33][3] 
new campmeter[33] 
new bool:pausecounter[33] 
new bool:bombplanted 
new bool:de_map 
new camptolerancedefending=180 
new camptoleranceattacking=200 
new camptime=20 
new healthpunish=10 
new campwarning[]="No camping allowed on this server!" 
new camppunish[]="Last Warning!" 
new campkill[]="%s has been killed due to camping!" 

public sqrt(num) {  
   new div = num;  
   new result = 1;  
   while (div > result) {   // end when div == result, or just below 
      div = (div + result) / 2   // take mean value as new divisor 
      result = num / div 
   }  
   return div; 
}  

public unpausecounter(parm[]) { 
   new id = parm[0] 
   pausecounter[id]=false 
   return PLUGIN_CONTINUE 
} 

public checkcamping(){ 
   if (get_cvar_num("sv_anticamping")==0){ 
      set_task(1.0,"checkcamping",1)  
      return PLUGIN_CONTINUE 
   } 
   new players[32] 
   new numberofplayers 
   new variance[3] 
   new average[3] 
   new variancetotal 
   new standarddeviation 
   new message[256] 
   new id 
   new team 
   new i 
   new j 
   get_players(players, numberofplayers, "a") 
   for (i = 0; i < numberofplayers; ++i) { 
      while (i < numberofplayers && pausecounter[players[i]]){ 
         ++i 
      } 
      if (i >= numberofplayers){ 
         set_task(1.0,"checkcamping",1)  
         return PLUGIN_CONTINUE 
      } 
      id=players[i] 
      for (j = 0; j < 3; ++j) { 
         playercoord4[id][j]=playercoord3[id][j] 
         playercoord3[id][j]=playercoord2[id][j] 
         playercoord2[id][j]=playercoord1[id][j] 
         playercoord1[id][j]=playercoord0[id][j] 
      } 
      get_user_origin(id, playercoord0[id], 0) 
      for (j = 0; j < 3; ++j) { 
         average[j]=(playercoord0[id][j]+  
                     playercoord1[id][j]+  
                     playercoord2[id][j]+  
                     playercoord3[id][j]+  
                     playercoord4[id][j])/5 
         variance[j]=(((playercoord0[id][j]-average[j])*(playercoord0[id][j]-average[j])+  
                       (playercoord1[id][j]-average[j])*(playercoord1[id][j]-average[j])+  
                       (playercoord2[id][j]-average[j])*(playercoord2[id][j]-average[j])+  
                       (playercoord3[id][j]-average[j])*(playercoord3[id][j]-average[j])+  
                       (playercoord4[id][j]-average[j])*(playercoord4[id][j]-average[j]))/4) 
      } 
      variancetotal=variance[0]+variance[1]+variance[2] 
      standarddeviation=sqrt(variancetotal) 
      team = get_user_team(id) 
      if (!de_map){ 
         if (team==2)   // Team 1 = Terro, Team 2 = CT 
            campmeter[id]+=(camptoleranceattacking-standarddeviation)/camptime 
         else 
            campmeter[id]+=(camptoleranceattacking-standarddeviation)/camptime 
      } 
      else if (bombplanted){ 
         if (team==1)   // Team 1 = Terro, Team 2 = CT 
            campmeter[id]=0 
         else 
            campmeter[id]+=(camptoleranceattacking-standarddeviation)/camptime 
      } 
      else{ 
         if (team==2)   // Team 1 = Terro, Team 2 = CT 
            campmeter[id]+=(camptolerancedefending-standarddeviation)/camptime 
         else 
            campmeter[id]+=(camptoleranceattacking-standarddeviation)/camptime 
      } 

      if (campmeter[id]<0) 
         campmeter[id]=0 
      else if (campmeter[id]>100){ 
         if (get_user_health(id)-healthpunish<=0){ 
            set_hudmessage(200, 100, 0, -1.0, 0.3, 0, 1.0, 10.0, 0.1, 0.1, 3) 
            new playername[64] 
            get_user_name(id,playername,63) 
            format(message,255,campkill,playername) 
            show_hudmessage(0,message) 
         } 
//         set_user_health(id, get_user_health(id)-healthpunish)	
// Remove the comments from the line above if you rather just take health off without slap
// Don't forget to comment the line below though if you do that
         user_slap(id,healthpunish)
         campmeter[id]=100 
      } 
      if (campmeter[id]>90){ 
         set_hudmessage(255, 255, 255, -1.0, 0.35, 0, 1.0, 1.0, 0.1, 0.1, 4) 
         show_hudmessage(id,camppunish) 
      } 
      else if (campmeter[id]>50){ 
         set_hudmessage(255, 255, 255, -1.0, 0.35, 0, 1.0, 1.0, 0.1, 0.1, 4) 
         show_hudmessage(id,campwarning) 
      } 
   } 
   set_task(1.0,"checkcamping",1)  
   return PLUGIN_CONTINUE 
} 

public damage_event(id){ 
   if (get_cvar_num("sv_anticamping")==0) 
      return PLUGIN_CONTINUE 
   new enemy = get_user_attacker(id) 
   if (get_user_team(id)!=get_user_team(enemy)){ 
      campmeter[id]=0 
      campmeter[enemy]=0 
   } 
   return PLUGIN_CONTINUE 
} 

public new_round(id){ 
   if (get_cvar_num("sv_anticamping")==0) 
      return PLUGIN_CONTINUE 
   bombplanted=false 
   pausecounter[id]=true 
   campmeter[id]=0 
   new Float:freezetime = get_cvar_float("mp_freezetime")+1.0 
   new parm[1] 
   parm[0]=id 
   set_task(freezetime,"unpausecounter",0,parm,1) 
   return PLUGIN_CONTINUE 
} 

public bartime_event(id){ 
   if (get_cvar_num("sv_anticamping")==0) 
      return PLUGIN_CONTINUE 
   pausecounter[id]=true 
   campmeter[id]=0 
   new Float:bar_time=float(read_data(1)+1) 
   new parm[1] 
   parm[0]=id 
   set_task(bar_time,"unpausecounter",0,parm,1) 
   return PLUGIN_CONTINUE 
} 

public bomb_planted(){ 
   if (get_cvar_num("sv_anticamping")==0) 
      return PLUGIN_CONTINUE 
   bombplanted=true 
   return PLUGIN_CONTINUE 
} 

public got_bomb(id){  
   if (get_cvar_num("sv_anticamping")==0) 
      return PLUGIN_CONTINUE 
   de_map=true 
   return PLUGIN_CONTINUE 
} 

public round_end(){ 
   if (get_cvar_num("sv_anticamping")==0) 
      return PLUGIN_CONTINUE 
   new players[32] 
   new numberofplayers 
   new id 
   new i 
   get_players(players, numberofplayers, "a") 
   for (i = 0; i < numberofplayers; ++i) { 
      id=players[i] 
      pausecounter[id]=true 
   } 
   return PLUGIN_CONTINUE 
} 

public plugin_init()   
{   
   register_plugin("Anti-Camping","1.01","SpaceDude") 
   register_event("Damage", "damage_event", "b", "2!0") 
   register_event("BarTime","bartime_event","b") 
   register_event("ResetHUD", "new_round", "b") 
   register_event("SendAudio", "bomb_planted", "a", "2&%!MRAD_BOMBPL") 
   register_event("SendAudio", "round_end", "a", "2&%!MRAD_terwin","2&%!MRAD_ctwin","2&%!MRAD_rounddraw") 
   register_event("StatusIcon", "got_bomb", "be", "1=1", "1=2", "2=c4") 
   register_cvar("sv_anticamping","1",0) 
   set_task(1.0,"checkcamping",1) 
   return PLUGIN_CONTINUE 
} 

